#version 430

layout (location = 0) in vec3 VertexPosition;
layout (location = 1) in vec3 VertexNormal;

uniform mat4 M;
uniform mat4 V;
uniform mat4 P;
uniform vec3 cameraPosition;

out vec3 Normal;
out vec3 Position;

void main() {

	gl_Position = P * V * M * vec4(VertexPosition, 1.0f);
	//Normal = vec3(V * M * vec4(VertexNormal, 0.0));
	//Position = vec3(V * M * vec4(VertexPosition, 0.0));
	Normal = mat3(transpose(inverse(M))) * VertexNormal;
	Position = vec3(M * vec4(VertexPosition, 1.0f));
}